// LPTDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LPT.h"
#include "LPTDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "JsPrinterDll.h"
#pragma comment(lib, "JsPrinterDll")

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLPTDlg dialog

CLPTDlg::CLPTDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLPTDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLPTDlg)
	bHex = FALSE;
	iPrintNum = 1;
	m_strTx = _T("Welcome to use the impact and thermal printer manufactured by professional POS receipt printer company!\n");
	hLpt=INVALID_HANDLE_VALUE;
	strLptName="LPT1";
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLPTDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLPTDlg)
	DDX_Check(pDX, IDC_CHECK_HEX, bHex);
	DDX_Text(pDX, IDC_EDIT_PRINUM, iPrintNum);
	DDV_MinMaxInt(pDX, iPrintNum, 1, 1000);
	DDX_Text(pDX, IDC_EDIT_TX, m_strTx);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLPTDlg, CDialog)
	//{{AFX_MSG_MAP(CLPTDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_CLR, OnButtonClr)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_JIAN, OnButtonJian)
	ON_BN_CLICKED(IDC_BUTTON_PRINT, OnButtonPrint)
	ON_CBN_SELCHANGE(IDC_COMBO_LPT, OnSelchangeComboLpt)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLPTDlg message handlers

BOOL CLPTDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	((CComboBox*)GetDlgItem(IDC_COMBO_LPT))->SetCurSel(0);

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLPTDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CLPTDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CLPTDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CLPTDlg::OnButtonClr() 
{
	// TODO: Add your control notification handler code here
		// TODO: Add your control notification handler code here
	m_strTx.Empty();
	UpdateData(FALSE);
}

void CLPTDlg::OnButtonAdd() 
{
	// TODO: Add your control notification handler code here
	iPrintNum++;
	UpdateData(FALSE);
}

void CLPTDlg::OnButtonJian() 
{
	// TODO: Add your control notification handler code here
	iPrintNum--;
	if(iPrintNum<=0)
	{
		iPrintNum=1;
	}
	UpdateData(FALSE);
}


void CLPTDlg::OnSelchangeComboLpt() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	((CComboBox*)GetDlgItem(IDC_COMBO_LPT))->GetWindowText(strLptName);
//	AfxMessageBox(strLptName);
}

extern int String2Hex(char *SendStr, char *SendHex);
void CLPTDlg::OnButtonPrint() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_strTx.GetLength()==0)
	{
		AfxMessageBox("Send data is empty!");
		return ;
	}
	if(hLpt==INVALID_HANDLE_VALUE)
	{
		hLpt=OpenLptA(strLptName);
		if(hLpt==INVALID_HANDLE_VALUE)
		{
			AfxMessageBox(_T("Open failed!"));
			return;
		}
	}
	char *sendbuf;
    sendbuf=(LPTSTR)(LPCTSTR)m_strTx;
	DWORD Bytes=strlen(sendbuf);
	DWORD BytesWriten;
	if(bHex==1)  //ʮƷ
	{
		char *SendHex=new char[Bytes/2];
		DWORD HexLength;
		HexLength=String2Hex(sendbuf,SendHex);
		if(HexLength==0)
		{
			CloseLpt(hLpt); 
			hLpt=INVALID_HANDLE_VALUE;
			AfxMessageBox(_T("Character input is incorrect"));
			return;
		}
		if(!WriteLpt(hLpt,SendHex,HexLength,&BytesWriten))  
		{
			AfxMessageBox(_T("Write failed"));
		}
		delete[] SendHex;
	}
	else  //ӡַ
	{
		int i=iPrintNum;       //ӡ
		while(i--)
		{
			if(!WriteLpt(hLpt,sendbuf,Bytes,&BytesWriten))  
			{
				AfxMessageBox(_T("Write failed!"));
				break;
			}
		}//end while 
	}
	CloseLpt(hLpt); 
	hLpt=INVALID_HANDLE_VALUE;
}

void CLPTDlg::OnOK()
{
	
}